getwd()
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

## Packages
set.seed(717)
library(cubature)
library(lava) 
library(ggplot2)
library(mcGlobaloptim) 
library(DiceKriging) 
library(nloptr) 
library(MASS)
library(mcmc)
library(geoR)
library(RobustCalibration)
library(lhs)
library(RobustGaSP)
library(numDeriv)
library(ggplot2)
library(rTensor)
library(plotly)
library(tensorA)
library(proxy)
library(abind)
library(scatterplot3d)
library(Matrix)

load("s1-ini-setting.RData")

## Model: f(x) = B*U1*U2*x; B: 3*3*2, U1/2: 3*3, x:3*2
dim.b = c(3,3,3); dim.u1 = c(2,3); dim.u2 = c(4,3); dim.x = c(2,3)
dim.f = c(2,4,2); t1 = dim.f[1]; t2 = dim.f[2]; t3 = dim.f[3]; 
dim.h = prod(dim.f); dim.mode = length(dim.f)
d = 3; lower.x = rep(0,d); upper.x = rep(1,d)

B <- e1.ini.set$B
U_mat <- e1.ini.set$U_mat
V <- e1.ini.set$V

true.model <- function(x){
  X1 = sin(5*x); X2 = cos(x)
  X = matrix(cbind(X1,X2),dim.x)
  return(array(ttm(V, X, m = 3)@data,dim.f))
}
h <- function(x) sum(true.model(x))

x.star = directL(function(x0) -h(x0),lower.x,upper.x,control=list(xmtl_rel=1e-8, maxeval=1000))$par
x.star = t(as.matrix(x.star))
t.star = true.model(x.star); h.star = h(x.star)

## Kernel
norm0 <- function(x1,x2) as.matrix(dist(x1,x2,method = "Euclidean"))
norm1 <- function(x1,x2){
  nor = list()
  for(i in 1:d){
    nor[[i]] = norm0(x1[,i],x2[,i])}
  return(nor)
} 

mat0 <- function(x) matern(x, phi=1, kappa=5/2)
gau0 <- function(x) exp(-x^2)
exp0 <- function(x) exp(-abs(x))

ker.sele <- function(x1,x2,theta,ker){
  x = norm1(x1,x2)
  dis = Map(function(x0,th) x0/th,x,theta)
  R0 = Map(function(x0) ker(x0),dis)
  R = Reduce("*", R0)
  return(R)
}

noise <- function(x1,x2){
  no.ind = which(apply(x1, 1, function(row_a) apply(x2, 1, function(row_b) all(row_a == row_b))), arr.ind = TRUE)
  no.0 = matrix(0,nrow(x2),nrow(x1))
  no.0[no.ind] = 1
  return(t(no.0))
}


################################################################################
#### GP ########################################################################
################################################################################
################################################################################
## Our proposed method: NS-mtGP
vec.lab = list()
vec.lab[[1]] = dim.h*(dim.h+1)/2
vec.lab[[2]] = d
vec.lab[[3]] = vec.lab[[4]] = 1
group.lab <- unlist(Map(rep, LETTERS[1:length(vec.lab)], unlist(vec.lab)))
dim.hyper.mt = length(group.lab)

lower.th = c(unlist(Map(rep, c(1e-1,1e-3,1e-2,1e-10), unlist(vec.lab))))
upper.th = c(unlist(Map(rep, c(1,10,10,1e-2), unlist(vec.lab))))

sig.mt <- function(t,ome){
  O = matrix(0,t,t)
  O[lower.tri(O, diag = T)] <- ome
  return(O)
}

likeli.mt <- function(x1,x2,y,n,t0,the){
  the0 = split(the, group.lab)
  
  k.ini = the0[[3]]*ker.sele(x1,x2,the0[[2]],mat0)+the0[[4]]*noise(x1,x2)
  omega = sig.mt(t0,the0[[1]])%*%t(sig.mt(t0,the0[[1]]))
  k.y = kronecker(k.ini,omega)
  sol.k.y = kronecker(solve(k.ini),solve(omega))
  
  log.likeli = determinant(k.y,logarithm=TRUE)$modulus+t(c(y))%*%sol.k.y%*%c(y)
  return(list(like=log.likeli, the0=the0))
}
# likeli.mt(x,x,y,k.ind,n,dim.h,c(runif(dim.hyper.mt)))


mtgp.hat <- function(x.new,x,y,n,n.test,t0,hy){
  x.new = matrix(x.new,n.test,d)
  omega = sig.mt(t0,hy[[1]])%*%t(sig.mt(t0,hy[[1]]))
  
  k.mt.s0 = hy[[3]]*ker.sele(x,x,hy[[2]],mat0)+hy[[4]]*noise(x,x)
  k.mt.s = kronecker(k.mt.s0,omega)
  
  k.mt.10 = hy[[3]]*ker.sele(x.new,x,hy[[2]],mat0)+hy[[4]]*noise(x.new,x)
  k.mt.1 = kronecker(k.mt.10,omega)
  
  k.mt.00 = hy[[3]]*ker.sele(x.new,x.new,hy[[2]],mat0)+hy[[4]]*noise(x.new,x.new)
  k.mt.0 = kronecker(k.mt.00,omega)
  
  k.oth = k.mt.1%*%kronecker(solve(k.mt.s0),solve(omega))
  
  f.hat = k.oth%*%c(y)
  var.hat = k.mt.0-k.oth%*%t(k.mt.1)
  
  result = list(mean = f.hat, cov = var.hat)
  return(result)
}
# mtgp.hat(ora.x.star,ora.ind.star,x,y,k.ind,n,1,dim.h,split(the, group.lab))


EIJ <- function(i,j){
  E0 = matrix(0,dim.h,dim.h); E0[i,j] = 1
  return(E0)
}

der.l <- function(x1,x2,y,n,the){
  the0 = split(the, group.lab)
  ome = the0[[1]]; th = the0[[2]]; sig2 = the0[[3]]; tau2 = the0[[4]]
  
  J <- function(i){
    E0 = matrix(0,dim.h,dim.h); E0[i,i] = exp(sig.mt(dim.h,the0[[1]])[i,i])
    return(E0)
  }
  
  k.ini0 = ker.sele(x1,x2,the0[[2]],mat0)
  k.ini = the0[[3]]*k.ini0+the0[[4]]*noise(x1,x2)
  omega = sig.mt(dim.h,the0[[1]])%*%t(sig.mt(dim.h,the0[[1]]))
  sol.k.ini = solve(k.ini); sol.o = solve(omega)
  
  al.k = sol.k.ini%*%k.ini0%*%sol.k.ini
  der.l.sig = dim.h*tr(sol.k.ini%*%k.ini0)-t(c(y))%*%kronecker(al.k,sol.o)%*%c(y)
  der.l.tau2 = dim.h*tr(sol.k.ini)-t(c(y))%*%kronecker(sol.k.ini,sol.o)%*%c(y)
  
  der.th = array(jacobian(function(theta) ker.sele(x1,x2,theta,mat0), th),dim=c(n,n,d))
  der.l.th.i <- function(der) sig2*(dim.h*tr(sol.k.ini)-t(c(y))%*%kronecker(
    sol.k.ini%*%der%*%sol.k.ini,omega)%*%c(y))
  der.l.th = apply(der.th,3,der.l.th.i)
  
  der.l.phi.ij <- function(i,j) as.numeric(n*tr(sol.o%*%(EIJ(i,j)%*%t(omega)+omega%*%EIJ(j,i)))-
                                             t(c(y))%*%kronecker(k.ini,sol.o%*%(EIJ(i,j)%*%t(omega)+omega%*%EIJ(j,i))%*%sol.o)%*%c(y))
  der.l.phi.1 = sapply(c(1:dim.h), function(i) {
    sapply(c(1:i), function(j) der.l.phi.ij(i, j))
  })
  
  der.l.phi.ii <- function(i) n*tr(sol.o%*%(J(i)%*%t(omega)+omega%*%J(i)))-
    t(c(y))%*%kronecker(k.ini,sol.o%*%(J(i)%*%t(omega)+omega%*%J(i))%*%sol.o)%*%c(y)
  der.l.phi.dig = apply(as.matrix(c(1:dim.h)),1, der.l.phi.ii)
  
  der.l.phi = matrix(0, dim.h, dim.h)
  for (i in 1:dim.h) {
    der.l.phi[i, 1:i] <- der.l.phi.1[[i]]
  }
  diag(der.l.phi) = der.l.phi.dig
  
  result = list(der.l.phi=der.l.phi[lower.tri(der.l.phi, diag = T)], der.l.th=der.l.th, der.l.sig=der.l.sig, der.l.tau2=der.l.tau2)
  return(result)
}



################################################################################
## Our proposed method: NS-mtGP-UCB
n = 5*d; m  = 10*d; lambda = 0.1; J.for=10

like.re.mt = hyper.mt = lapply(1:J.for, function(x) list())
x0.mt = y0.mt = ind0.mt = list(); fhat = lapply(1:J.for, function(x) list())
mtgp.bo = h.mt = list()
mse.x.mt = mae.y.mt = list()
regret.mt = ins.regret.mt = cum.regret.mt = list()


for(j.for.mt in 1:J.for){
  x = e1.ini.set$x 
  f = e1.ini.set$f 
  y = e1.ini.set$y.for[[j.for.mt]]
  
  ## Setting
  ######################################## BO ####################################
  hyper.mt.old = directL(function(the) likeli.mt(x,x,y,n,dim.h,the)$like,lower.th,upper.th,control=list(maxeval=1000))$par
  opts <- list("algorithm"="NLOPT_LD_LBFGS", "xmtl_rel"=1.0e-5)
  hyper.mt.new = nloptr(x0=hyper.mt.old,
                        eval_f = function(the) likeli.mt(x,x,y,n,dim.h,the)$like,
                        eval_grad_f=function(the) unlist(der.l(x,x,y,n,the)),
                        opts=opts,lb = lower.th, ub = upper.th)$solution
  
  hyper.mt.new = hyper.mt.old
  like.re.mt[[j.for.mt]][[1]] = likeli.mt(x,x,y,n,dim.h,hyper.mt.new)
  hyper.mt[[j.for.mt]][[1]] = like.re.mt[[j.for.mt]][[1]]$the0
  
  x0.mt[[j.for.mt]] = x; y0.mt[[j.for.mt]] = y; n.mt = n
  x.new.mt = t(as.matrix(x[which.max(apply(x,1,h)),]))
  y.new.mt = f[,,,which.max(apply(x,1,h))]
  
  hyper.mt.ucb = unlist(hyper.mt[[j.for.mt]][[1]]); delta.mt = 0.05
  fhat[[j.for.mt]][[1]] = mtgp.hat(x.new.mt,x,y0.mt[[j.for.mt]],n.mt,1,dim.h,hyper.mt[[j.for.mt]][[1]])
  
  for(i.mt in 1:m){
    x.new.mt = t(t(randomLHS(1,d))*(upper.x-lower.x) + lower.x)
    
    fhat[[j.for.mt]][[i.mt+1]] = mtgp.hat(x.new.mt,x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],n.mt,n.test=1,dim.h,hyper.mt[[j.for.mt]][[i.mt]])
    y.new.mt = true.model(x.new.mt)+array(rnorm(dim.h, mean=0, sd=lambda), dim=c(dim.f))
    
    x0.mt[[j.for.mt]] = rbind(x0.mt[[j.for.mt]], x.new.mt)
    y0.mt[[j.for.mt]] = abind(y0.mt[[j.for.mt]], y.new.mt, along = 4)
    
    n.mt = n+i.mt
    
    if(i.mt %% 5 == 0){
      hyper.mt.ucb = nloptr(x0=hyper.mt[[j.for.mt]][[i.mt]],
                            eval_f = function(the) likeli.mt(x0.mt[[j.for.mt]],x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],n.mt,dim.h,the)$like,
                            eval_grad_f=function(the) unlist(der.l(x0.mt[[j.for.mt]],x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],n.mt,the)),
                            opts=opts,lb = lower.th, ub = upper.th)$solution
    }else{
      hyper.mt.ucb = hyper.mt.ucb
    }
    
    like.re.mt[[j.for.mt]][[i.mt+1]] = likeli.mt(x0.mt[[j.for.mt]],x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],n.mt,dim.h,hyper.mt.ucb)
    hyper.mt[[j.for.mt]][[i.mt+1]] = like.re.mt[[j.for.mt]][[i.mt+1]]$the0
    print(i.mt)
  }
  
  mtgp.bo[[j.for.mt]] = Map(function(a) true.model(a),split(x0.mt[[j.for.mt]],row(x0.mt[[j.for.mt]])))
  h.mt[[j.for.mt]] = apply(x0.mt[[j.for.mt]],1,h)
  
  mse.x.mt[[j.for.mt]] = apply(x0.mt[[j.for.mt]],1,function(x) mean((x-x.star)^2))
  mae.y.mt[[j.for.mt]] = unlist(lapply(fhat[[j.for.mt]],function(a) mean(abs((a$mean-c(t.star))/c(t.star)))))
  regret.mt[[j.for.mt]] = h.star-unlist(h.mt[[j.for.mt]])
  
  ins.regret.mt[[j.for.mt]] = h.star-cummax(h.mt[[j.for.mt]])
  cum.regret.mt[[j.for.mt]] = cumsum(ins.regret.mt[[j.for.mt]])
  
  layout(matrix(1, nrow = 1, ncol = 1))
  plot(rep(h.star,(n.mt-n+1)),type="b",lwd=3,lty=1,pch=1,col=1,ylim=c(cummax(h.mt[[j.for.mt]])[n],h.star))
  lines(cummax(h.mt[[j.for.mt]])[n:n.mt],type="b",lwd=3,lty=2,pch=2,col=2)
  
  plot(log(ins.regret.mt[[j.for.mt]]+1e-10)[n:n.mt],type="b",lwd=3,lty=1,pch=1,col=1)
  
  print(j.for.mt)
}



fmv.rs.list = list(like.re.mt=like.re.mt, hyper.mt=hyper.mt, 
                    x0.mt=x0.mt, y0.mt=y0.mt, mtgp.bo=mtgp.bo, h.mt=h.mt, 
                    mse.x.mt=mse.x.mt, mae.y.mt=mae.y.mt, 
                    regret.mt=regret.mt, ins.regret.mt=ins.regret.mt, cum.regret.mt=cum.regret.mt)
save(fmv.rs.list, file="s1.fmv.rs.RData")


